#!/usr/bin/perl

# tweak.pl -- manipulates various storage management agent settings.
#             This is intended to be used from a rollout or random sysadmin script.             
# mpd 2/04

use strict;

our $a=$ARGV[0];
our $b=$ARGV[1];

foreach ($a) {
  die("$0: Usage: (port|wall|log|auth) value\n") unless ($a =~ /port|wall|log|auth/);  
  set_int ('RaidAgnt.pps','agent.startupPortNum',$b) if ($a eq 'port');
  set_bool('RaidAgnt.pps','agent.enable.broadcasts',$b) if ($a eq 'wall');
  set_bool('RaidAgnt.pps','agent.enable.logEventsWithOS',$b) if ($a eq 'log');
  set_bool('RaidAgnt.pps','agent.enable.security',$b) if ($a eq 'auth');
  restart();
}

sub get_propfile_lines {
   my ($filename) = @_;
   open(PROP_FILE,$filename) or die("Error opening: $filename: $!\n");
   my @lines=<PROP_FILE>;
   return @lines;
}

sub set_propfile_lines {
   my ($filename, @lines) = @_;
   open(PROP_FILE2,">$filename") or die("Error writing: $filename: $!\n");
   foreach my $l (@lines) { print PROP_FILE2 $l; }
   close(PROP_FILE2);
}

sub set_prop {
   my ($filename, $option, $value) = @_;
   my @lines=get_propfile_lines $filename;
   my $match=0;
   foreach my $l (@lines) { if ($l=~/$option/) { $l="$option=$value\n"; $match=1; } }
   push @lines, "$option=$value\n" if ($match!=1);
   set_propfile_lines($filename,@lines); 
}

sub set_bool {
   my ($file,$option,$setting)=@_;
   die ("Required argument: true/false\n") unless $setting=~/^true|false/; 
   set_prop($file,$option,$setting);
}

sub set_int {
   my ($file,$option,$setting)=@_;
   die("Required argument: integer\n") unless $setting=~/^\d+/;
   set_prop($file,$option,$setting);
}

sub restart {
   system("/etc/init.d/raid_agent stop");
   system("/etc/init.d/raid_agent start");
   system("/etc/init.d/stor_agent stop");
   system("/etc/init.d/stor_agent start");
}

__END__

