#!/bin/sh

# Launcher script for Adaptec Storage Manager GUI

unset JAVA_HOME CLASSPATH JFLAGS 

OS=`uname -s`

case $OS in
   "UnixWare")
	   INSTDIR=/opt/StorMan

           # Commenting the following checks as JRE is now packaged 
           # in RaidMan.ds and JAVA_HOME will point to that in the
           # installation directory.
           #if [ -d /usr/java2 ]; then
               # Using Java 2 JDK
           #   JAVA_HOME=/usr/java2
           #elif [ -d /usr/jre2 ]; then
               # Using JRE 2 JDK
           #   JAVA_HOME=/usr/jre2
           #elif [ -d /usr/java ]; then
               # Using Java 1 JDK
           #   JAVA_HOME=/usr/java
           #elif [ -d /usr/jre ]; then
              # Using Java 1 JRE
           #   JAVA_HOME=/usr/jre
           #fi
	   JAVA_HOME="$INSTDIR/jre"
	   export JAVA_HOME
	
	   THREADS_FLAG=native 
           JAVA_COMPILER=NONE
           JFLAGS="-mx192m -ms8m"
           export JAVA_COMPILER JFLAGS
	   ;;
   "SunOS")
           INSTDIR=/opt/StorMan

           # Commenting the following checks as JRE is now packaged 
           # in RaidMan.ds and JAVA_HOME will point to that in the
           # installation directory.
           #if [ -d /usr/java2 ]; then
               # Using Java 2 JDK
           #   JAVA_HOME=/usr/java2
           #elif [ -d /usr/jre2 ]; then
               # Using JRE 2 JDK
           #   JAVA_HOME=/usr/jre2
           #elif [ -d /usr/java ]; then
               # Using Java 1 JDK
           #   JAVA_HOME=/usr/java
           #elif [ -d /usr/jre ]; then
              # Using Java 1 JRE
           #   JAVA_HOME=/usr/jre
           #fi
	   JAVA_HOME="$INSTDIR/jre"
	   export JAVA_HOME

           THREADS_FLAG=native
           JAVA_COMPILER=NONE
           JFLAGS="-mx192m -ms8m"
           export JAVA_COMPILER JFLAGS
           if [ -f $INSTDIR/libSTORARC.so ]
           then
               cd /dev/cfg
               # Create the aac device node if it cannot be found
               DEVNODEFOUND=0
               for f in /dev/cfg/c*
               do
				   NODE=`ls -l $f | cut -f2 -d'>' | sed "s,scsi\$,aac,"`
                   ls $NODE > /dev/null 2>&1
				   if [ $? -eq 0 ]
				   then
				   		DEVNODEFOUND=1
				   fi
               done
               [ $DEVNODEFOUND -eq 0 ] && devfsadm -i aac
               cd $INSTDIR
           fi
           ;;
   "OpenUNIX")
      	   INSTDIR=/opt/StorMan
	  
	   if [ -d /usr/java2 ]; then
	       # Using Java 2 JDK	
	      JAVA_HOME=/usr/java2
	   elif [ -d /usr/jre2 ]; then
	       # Using JRE 2 JDK	
	      JAVA_HOME=/usr/jre2
	   elif [ -d /usr/java ]; then
	       # Using Java 1 JDK	
	      JAVA_HOME=/usr/java
           elif [ -d /usr/jre ]; then
              # Using Java 1 JRE   
	      JAVA_HOME=/usr/jre
	   fi
	  
	   THREADS_FLAG=native 
           JAVA_COMPILER=NONE
           JFLAGS="-mx192m -ms8m"
           export JAVA_COMPILER JFLAGS
	   ;;
   "SCO_SV" )   
	   INSTDIR=/opt/StorMan
	
           # Commenting the following checks as JRE is now packaged 
           # in RaidMan.ds and JAVA_HOME will point to that in the
           # installation directory.
           #if [ -d /usr/java2 ]; then
               # Using Java 2 JDK
           #   JAVA_HOME=/usr/java2
           #elif [ -d /usr/jre2 ]; then
               # Using JRE 2 JDK
           #   JAVA_HOME=/usr/jre2
           #elif [ -d /usr/java ]; then
               # Using Java 1 JDK
           #   JAVA_HOME=/usr/java
           #elif [ -d /usr/jre ]; then
              # Using Java 1 JRE
           #   JAVA_HOME=/usr/jre
           #fi
	   JAVA_HOME="$INSTDIR/jre"
	   export JAVA_HOME
	
	   # THREADS_FLAG=green    
           JAVA_COMPILER=NONE
           JFLAGS="-mx192m -ms8m"
           export JAVA_COMPILER JFLAGS
	   ;;
   "Linux")
	   INSTDIR=/usr/StorMan
           Arch=`uname -m` 
           if [ "$Arch" = "ia64" ];then 
	      JAVA_HOME="./IBMJava2-ia64-13"   # use bundled JRE 64
  	   else 	   
       	      JAVA_HOME="."   # use bundled JRE 32
           fi        
           JAVA_BIN=$JAVA_HOME/jre/bin
           JAVA_LIB=$JAVA_HOME/jre/lib

      ;;
   "FreeBSD")
           INSTDIR=/opt/StorMan
           JAVA_HOME="./jre"   # use bundled JRE
           JAVA_BIN=$JAVA_HOME/bin
           JAVA_LIB=$JAVA_HOME/lib   
           ;;      
esac
 
if [ ! "$JAVA_BIN" ]; then
  JAVA_BIN=$JAVA_HOME/bin
fi

if [ ! "$JAVA_LIB" ]; then
  JAVA_LIB=$JAVA_HOME/lib
fi

LD_LIBRARY_PATH=$INSTDIR:$LD_LIBRARY_PATH
if [ -f $INSTDIR/libstdc++.so.5 ] && ldd $INSTDIR/libSTORUTIL.so | grep libstdc++.so.5 > /dev/null 2>&1
then
	LD_PRELOAD=$INSTDIR/libstdc++.so.5
fi

export LD_LIBRARY_PATH JAVA_HOME JAVA_BIN JAVA_LIB CLASSPATH THREADS_FLAG LD_PRELOAD

cd $INSTDIR

if [ "$OS" = "Linux" ]; then
   $JAVA_BIN/java -cp $INSTDIR/RaidMan.jar com.ibm.sysmgt.raidmgr.mgtGUI.Launch $* 
else
   # if JDK exists on system, use it. Otherwise use JRE.
   if [ -f $JAVA_BIN/java ]; then
      $JAVA_BIN/java $JFLAGS -classpath $INSTDIR/RaidMan.jar:$JAVA_LIB/classes.zip com.ibm.sysmgt.raidmgr.mgtGUI.Launch $* </dev/null
   else
      $JAVA_BIN/jre $JFLAGS -nojit -cp $INSTDIR/RaidMan.jar -cp $JAVA_LIB/classes.zip com.ibm.sysmgt.raidmgr.mgtGUI.Launch $* </dev/null
   fi
fi
